#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
uniform mat3 NormalMatrix;

in vec3 gs_params[1]; // radius, energy, 1/mass

out vec3 ec_pos;
out vec2 pos_zw;
out vec2 uv;

layout(points) in;
layout(triangle_strip, max_vertices = 24) out;

#define EMIT_VERTEX(VTX, EYE, TC) \
	ec_pos = EYE; \
	pos_zw = VTX.zw; \
	uv = tex_coords[TC]; \
	gl_Position = VTX; \
	EmitVertex()

#define MAKE_QUAD(A, B, C, D) \
	EMIT_VERTEX(vertices[A], ec_eye[A], 0); \
	EMIT_VERTEX(vertices[B], ec_eye[B], 1); \
	EMIT_VERTEX(vertices[D], ec_eye[D], 2); \
	EMIT_VERTEX(vertices[C], ec_eye[C], 3); \
	EndPrimitive()


vec3 cube_vertices[8] = vec3[](
    vec3( 1.0,  1.0, -1.0),
    vec3(-1.0,  1.0, -1.0),
    vec3(-1.0, -1.0, -1.0),
    vec3( 1.0, -1.0, -1.0),
    vec3( 1.0,  1.0,  1.0),
    vec3(-1.0,  1.0,  1.0),
    vec3(-1.0, -1.0,  1.0),
    vec3( 1.0, -1.0,  1.0)
);

vec2 tex_coords[4] = vec2[](
	vec2(1.0, 0.0),
	vec2(0.0, 0.0),
	vec2(1.0, 1.0),
	vec2(0.0, 1.0)
);


#include <matrix_include.vert>

void main()
{
	if ( gs_params[0].x <= 0.0 ) return;

	vec3 center = gl_in[0].gl_Position.xyz;
	float radius = gs_params[0].x;

	mat3 mr;
	//float angle = (center.x + center.y + center.z)*0.1;// + gs_params[0].y*1.0;
	float angle = gs_params[0].y*9.0 - center.z*0.1;
	rotate_around_axis(normalize(center + vec3(0.0,0.0,5.0)), angle, mr);

	vec4 vertices[8];
	vec3 ec_eye[8];
	for (int i=0; i < 8; i++)
	{
		vec4 pos = vec4(center + mr*cube_vertices[i]*radius, 1.0);
		ec_eye[i] = vec3(ModelViewMatrix * pos);
		vertices[i] = ModelViewProjectionMatrix * pos;
	}

	MAKE_QUAD(3,2,1,0);

	MAKE_QUAD(4,5,6,7);

	MAKE_QUAD(6,5,1,2);

	MAKE_QUAD(7,3,0,4);

	MAKE_QUAD(5,4,0,1);

	MAKE_QUAD(7,6,2,3);
}
